/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

import org.pentaho.gis.shapefiles.Converter;
import org.pentaho.gis.shapefiles.Shape;

public class ShapeFileHeader {
    public int filecode;
    public int unused1;
    public int unused2;
    public int unused3;
    public int unused4;
    public int unused5;
    public int file_length;
    public int version;
    public int shapetype;
    public double bbox_xmin;
    public double bbox_ymin;
    public double bbox_xmax;
    public double bbox_ymax;
    public double bbox_zmin;
    public double bbox_zmax;
    public double bbox_mmin;
    public double bbox_mmax;

    public ShapeFileHeader(byte[] header) {
        this.filecode = Converter.getIntegerBig(header, 0);
        this.unused1 = Converter.getIntegerBig(header, 4);
        this.unused2 = Converter.getIntegerBig(header, 8);
        this.unused3 = Converter.getIntegerBig(header, 12);
        this.unused4 = Converter.getIntegerBig(header, 16);
        this.unused5 = Converter.getIntegerBig(header, 20);
        this.file_length = Converter.getIntegerBig(header, 24);
        this.version = Converter.getIntegerLittle(header, 28);
        this.shapetype = Converter.getIntegerLittle(header, 32);
        this.bbox_xmin = Converter.getDoubleLittle(header, 36);
        this.bbox_ymin = Converter.getDoubleLittle(header, 44);
        this.bbox_xmax = Converter.getDoubleLittle(header, 52);
        this.bbox_ymax = Converter.getDoubleLittle(header, 60);
        this.bbox_zmin = Converter.getDoubleLittle(header, 68);
        this.bbox_zmax = Converter.getDoubleLittle(header, 76);
        this.bbox_mmin = Converter.getDoubleLittle(header, 84);
        this.bbox_mmax = Converter.getDoubleLittle(header, 92);
    }

    public int getShapeType() {
        return this.shapetype;
    }

    public String getShapeTypeDesc() {
        return Shape.getEsriTypeDesc(this.shapetype);
    }
}

