/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Component;
import java.text.Format;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormattingTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Log logger = LogFactory.getLog(FormattingTableCellRenderer.class);
    private Format format;

    public FormattingTableCellRenderer(Format format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this.format = format;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            try {
                String formattedValue = this.format.format(value);
                return super.getTableCellRendererComponent(table, formattedValue, isSelected, hasFocus, row, column);
            }
            catch (Exception e) {
                logger.debug((Object)("Unable to format value " + value), (Throwable)e);
            }
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

