/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.edi2xml;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.edi2xml.Edi2Xml;
import org.pentaho.di.trans.steps.edi2xml.Edi2XmlData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="TypeExitEdi2XmlStep", name="BaseStep.TypeLongDesc.Edi2Xml", description="BaseStep.TypeTooltipDesc.Edi2Xml", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Utility", image="EDI2XML.svg", documentationUrl="http://wiki.pentaho.com/display/EAI/Edi+to+XML", i18nPackageName="org.pentaho.di.trans.steps.edi2xml")
public class Edi2XmlMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = Edi2XmlMeta.class;
    private String outputField;
    private String inputField;

    public String getInputField() {
        return this.inputField;
    }

    public void setInputField(String inputField) {
        this.inputField = inputField;
    }

    public String getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String outputField) {
        this.outputField = outputField;
    }

    public String getXML() throws KettleValueException {
        StringBuilder retval = new StringBuilder();
        retval.append("   " + XMLHandler.addTagValue((String)"inputfield", (String)this.inputField));
        retval.append("   " + XMLHandler.addTagValue((String)"outputfield", (String)this.outputField));
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            this.setInputField(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"inputfield")));
            this.setOutputField(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"outputfield")));
        }
        catch (Exception e) {
            throw new KettleXMLException("Template Plugin Unable to read step info from XML node", (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.inputField = rep.getStepAttributeString(id_step, "inputfield");
            this.outputField = rep.getStepAttributeString(id_step, "outputfield");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Edi2Xml.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "inputfield", this.inputField);
            rep.saveStepAttribute(id_transformation, id_step, "outputfield", this.outputField);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Edi2Xml.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface r, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValueMetaString extra = null;
        if (!Utils.isEmpty((CharSequence)this.getOutputField())) {
            extra = new ValueMetaString(space.environmentSubstitute(this.getOutputField()));
            extra.setOrigin(origin);
            r.addValueMeta((ValueMetaInterface)extra);
        } else if (!Utils.isEmpty((CharSequence)this.getInputField())) {
            extra = r.searchValueMeta(space.environmentSubstitute(this.getInputField()));
        }
        if (extra != null) {
            extra.setStorageType(0);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving input from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        String realInputField = transMeta.environmentSubstitute(this.getInputField());
        if (prev.searchValueMeta(realInputField) != null) {
            cr = new CheckResult(1, "Step is seeing input field: " + realInputField, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            if (prev.searchValueMeta(realInputField).isString()) {
                cr = new CheckResult(1, "Field " + realInputField + " is a string type", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, "Field " + realInputField + " is not a string type!", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, "Step is not seeing input field: " + realInputField + "!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void setDefault() {
        this.outputField = "edi_xml";
        this.inputField = "";
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
        return new Edi2Xml(stepMeta, stepDataInterface, cnr, transMeta, disp);
    }

    public StepDataInterface getStepData() {
        return new Edi2XmlData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

