/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl.model.kettle.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metaverse.api.model.kettle.HopInfo;
import org.pentaho.metaverse.impl.model.kettle.LineageRepository;
import org.pentaho.metaverse.impl.model.kettle.json.AbstractMetaJsonSerializer;
import org.pentaho.metaverse.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransMetaJsonSerializer
extends AbstractMetaJsonSerializer<TransMeta> {
    private static TransMetaJsonSerializer instance;
    private static final Logger LOGGER;

    private TransMetaJsonSerializer() {
        this(TransMeta.class);
        this.setLineageRepository(LineageRepository.getInstance());
    }

    public static TransMetaJsonSerializer getInstance() {
        if (null == instance) {
            instance = new TransMetaJsonSerializer();
        }
        return instance;
    }

    @VisibleForTesting
    TransMetaJsonSerializer(Class<TransMeta> aClass) {
        super(aClass);
    }

    @VisibleForTesting
    TransMetaJsonSerializer(JavaType javaType) {
        super(javaType);
    }

    @VisibleForTesting
    TransMetaJsonSerializer(Class<?> aClass, boolean b) {
        super(aClass, b);
    }

    @Override
    protected List<String> getUsedVariables(TransMeta meta) {
        return meta.getUsedVariables();
    }

    @Override
    protected void serializeSteps(TransMeta meta, JsonGenerator json) throws IOException {
        json.writeArrayFieldStart("steps");
        for (StepMeta stepMeta : meta.getSteps()) {
            BaseStepMeta step = this.getBaseStepMetaFromStepMeta(stepMeta);
            LineageRepository repo = this.getLineageRepository();
            String id = stepMeta.getObjectId() == null ? stepMeta.getName() : stepMeta.getObjectId().toString();
            StringObjectId stepId = new StringObjectId(id);
            try {
                step.saveRep((Repository)repo, null, null, (ObjectId)stepId);
            }
            catch (KettleException e) {
                LOGGER.warn(Messages.getString("INFO.Serialization.Trans.Step", stepMeta.getName()), (Throwable)e);
            }
            json.writeObject((Object)step);
        }
        json.writeEndArray();
    }

    @Override
    protected void serializeHops(TransMeta meta, JsonGenerator json) throws IOException {
        json.writeArrayFieldStart("hops");
        int numberOfHops = meta.nrTransHops();
        for (int i = 0; i < numberOfHops; ++i) {
            TransHopMeta hopMeta = meta.getTransHop(i);
            HopInfo hopInfo = new HopInfo(hopMeta);
            json.writeObject((Object)hopInfo);
        }
        json.writeEndArray();
    }

    protected BaseStepMeta getBaseStepMetaFromStepMeta(StepMeta stepMeta) {
        StepMetaInterface smi;
        BaseStepMeta baseStepMeta = new BaseStepMeta();
        baseStepMeta.setParentStepMeta(stepMeta);
        if (stepMeta != null && (smi = stepMeta.getStepMetaInterface()) instanceof BaseStepMeta) {
            baseStepMeta = (BaseStepMeta)smi;
        }
        return baseStepMeta;
    }

    static {
        LOGGER = LoggerFactory.getLogger(TransMetaJsonSerializer.class);
    }
}

