/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl.model.kettle.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.pentaho.metaverse.api.model.JdbcResourceInfo;
import org.pentaho.metaverse.api.model.JndiResourceInfo;
import org.pentaho.metaverse.api.model.kettle.HopInfo;
import org.pentaho.metaverse.impl.model.ParamInfo;
import org.pentaho.metaverse.impl.model.kettle.LineageRepository;
import org.pentaho.metaverse.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransMetaJsonDeserializer
extends StdDeserializer<TransMeta> {
    private static TransMetaJsonDeserializer instance;
    private Repository repository;
    private static final Logger LOGGER;

    private TransMetaJsonDeserializer() {
        this(TransMeta.class, LineageRepository.getInstance());
    }

    public static TransMetaJsonDeserializer getInstance() {
        if (null == instance) {
            instance = new TransMetaJsonDeserializer();
        }
        return instance;
    }

    @VisibleForTesting
    TransMetaJsonDeserializer(Class<?> aClass) {
        super(aClass);
    }

    @VisibleForTesting
    TransMetaJsonDeserializer(Class<?> aClass, Repository repository) {
        super(aClass);
        this.setRepository(repository);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public TransMeta deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        TransMeta transMeta = null;
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        String name = node.get("name").textValue();
        String desc = node.get("description").textValue();
        String createdBy = node.get("createdby").textValue();
        String modifiedBy = node.get("lastmodifiedby").textValue();
        Date createdDate = new Date(node.get("created").asLong());
        Date modifiedDate = new Date(node.get("lastmodified").asLong());
        String path = node.get("path").textValue();
        transMeta = new TransMeta(null, name);
        transMeta.setDescription(desc);
        transMeta.setCreatedDate(createdDate);
        transMeta.setCreatedUser(createdBy);
        transMeta.setModifiedDate(modifiedDate);
        transMeta.setModifiedUser(modifiedBy);
        transMeta.setFilename(path);
        this.deserializeParameters(transMeta, node, mapper);
        this.deserializeVariables(transMeta, node, mapper);
        this.deserializeConnections(transMeta, node, mapper);
        this.deserializeSteps(transMeta, node, mapper);
        this.deserializeHops(transMeta, node, mapper);
        return transMeta;
    }

    protected void deserializeConnections(TransMeta transMeta, JsonNode node, ObjectMapper mapper) {
        ArrayNode connectionsArrayNode = (ArrayNode)node.get("connections");
        IExternalResourceInfo conn = null;
        for (int i = 0; i < connectionsArrayNode.size(); ++i) {
            JsonNode connNode = connectionsArrayNode.get(i);
            String className = connNode.get("@class").asText();
            try {
                JdbcResourceInfo db;
                Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
                conn = (IExternalResourceInfo)clazz.newInstance();
                conn = (IExternalResourceInfo)mapper.readValue(connNode.toString(), conn.getClass());
                DatabaseMeta dbMeta = null;
                if (conn instanceof JdbcResourceInfo) {
                    db = (JdbcResourceInfo)conn;
                    dbMeta = new DatabaseMeta(db.getName(), db.getPluginId(), DatabaseMeta.getAccessTypeDesc((int)0), db.getServer(), db.getDatabaseName(), String.valueOf(db.getPort()), db.getUsername(), db.getPassword());
                } else if (conn instanceof JndiResourceInfo) {
                    db = (JndiResourceInfo)conn;
                    dbMeta = new DatabaseMeta(db.getName(), db.getPluginId(), DatabaseMeta.getAccessTypeDesc((int)4), null, null, null, null, null);
                }
                transMeta.addDatabase(dbMeta);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn(Messages.getString("WARNING.Deserialization.Trans.Connections", conn.getName(), transMeta.getName()), (Throwable)e);
            }
        }
    }

    protected void deserializeParameters(TransMeta transMeta, JsonNode node, ObjectMapper mapper) throws IOException {
        ArrayNode paramsArrayNode = (ArrayNode)node.get("parameters");
        for (int i = 0; i < paramsArrayNode.size(); ++i) {
            JsonNode paramNode = paramsArrayNode.get(i);
            ParamInfo param = (ParamInfo)((Object)mapper.readValue(paramNode.toString(), ParamInfo.class));
            try {
                transMeta.addParameterDefinition(param.getName(), param.getDefaultValue(), param.getDescription());
                continue;
            }
            catch (DuplicateParamException e) {
                LOGGER.warn(Messages.getString("WARNING.Deserialization.Trans.DuplicateParam", param.getName()), (Throwable)e);
            }
        }
    }

    protected void deserializeVariables(TransMeta transMeta, JsonNode node, ObjectMapper mapper) throws IOException {
        ArrayNode varsArrayNode = (ArrayNode)node.get("variables");
        for (int i = 0; i < varsArrayNode.size(); ++i) {
            JsonNode paramNode = varsArrayNode.get(i);
            ParamInfo param = (ParamInfo)((Object)mapper.readValue(paramNode.toString(), ParamInfo.class));
            transMeta.setVariable(param.getName(), param.getValue());
        }
    }

    protected void deserializeSteps(TransMeta transMeta, JsonNode node, ObjectMapper mapper) throws IOException {
        ArrayNode stepsArrayNode = (ArrayNode)node.get("steps");
        String stepName = null;
        for (int i = 0; i < stepsArrayNode.size(); ++i) {
            JsonNode stepNode = stepsArrayNode.get(i);
            String className = stepNode.get("@class").asText();
            stepName = stepNode.get("name").asText();
            StringObjectId stepId = new StringObjectId(stepName);
            JsonNode attributes = stepNode.get("attributes");
            this.writeJsonAttributes(attributes, mapper, (ObjectId)stepId);
            JsonNode fields = stepNode.get("fields");
            this.writeJsonFields(fields, mapper, (ObjectId)stepId);
            try {
                Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
                BaseStepMeta meta = (BaseStepMeta)clazz.newInstance();
                meta.readRep(this.getRepository(), null, (ObjectId)stepId, transMeta.getDatabases());
                StepMetaInterface smi = (StepMetaInterface)meta;
                StepMeta step = new StepMeta(stepName, smi);
                transMeta.addStep(step);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn(Messages.getString("WARNING.Deserialization.Trans.Steps", stepName), (Throwable)e);
            }
        }
    }

    protected void writeJsonFields(JsonNode fields, ObjectMapper mapper, ObjectId stepId) throws IOException {
        List fieldLists = new ArrayList();
        fieldLists = (List)mapper.readValue(fields.toString(), fieldLists.getClass());
        int idx = 0;
        for (Map fieldAttrs : fieldLists) {
            for (String s : fieldAttrs.keySet()) {
                Object val = fieldAttrs.get(s);
                try {
                    if (val instanceof Integer) {
                        this.repository.saveStepAttribute(null, stepId, idx, s, (long)((Integer)val).intValue());
                        continue;
                    }
                    if (val instanceof Long) {
                        this.repository.saveStepAttribute(null, stepId, idx, s, ((Long)val).longValue());
                        continue;
                    }
                    if (val instanceof Double) {
                        this.repository.saveStepAttribute(null, stepId, idx, s, ((Double)val).doubleValue());
                        continue;
                    }
                    if (val instanceof Boolean) {
                        this.repository.saveStepAttribute(null, stepId, idx, s, ((Boolean)val).booleanValue());
                        continue;
                    }
                    this.repository.saveStepAttribute(null, stepId, idx, s, val == null ? null : (String)val);
                }
                catch (KettleException e) {
                    LOGGER.info(Messages.getString("INFO.Deserialization.Trans.SavingAttributes", s, String.valueOf(idx)), (Throwable)e);
                }
            }
            ++idx;
        }
    }

    protected void writeJsonAttributes(JsonNode attributes, ObjectMapper mapper, ObjectId stepId) throws IOException {
        Map attrs = new HashMap();
        attrs = (Map)mapper.readValue(attributes.toString(), attrs.getClass());
        for (String s : attrs.keySet()) {
            Object val = attrs.get(s);
            try {
                if (val instanceof Integer) {
                    this.repository.saveStepAttribute(null, stepId, s, (long)((Integer)val).intValue());
                    continue;
                }
                if (val instanceof Long) {
                    this.repository.saveStepAttribute(null, stepId, s, ((Long)val).longValue());
                    continue;
                }
                if (val instanceof Double) {
                    this.repository.saveStepAttribute(null, stepId, s, ((Double)val).doubleValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    this.repository.saveStepAttribute(null, stepId, s, ((Boolean)val).booleanValue());
                    continue;
                }
                this.repository.saveStepAttribute(null, stepId, s, val == null ? null : (String)val);
            }
            catch (KettleException e) {
                LOGGER.info(Messages.getString("INFO.Deserialization.Trans.SavingAttributes", s), (Throwable)e);
            }
        }
    }

    protected void deserializeHops(TransMeta transMeta, JsonNode root, ObjectMapper mapper) {
        ArrayNode hopsArray = (ArrayNode)root.get("hops");
        for (int i = 0; i < hopsArray.size(); ++i) {
            JsonNode hopNode = hopsArray.get(i);
            try {
                HopInfo hop = (HopInfo)mapper.readValue(hopNode.toString(), HopInfo.class);
                if (hop == null) continue;
                TransHopMeta hopMeta = new TransHopMeta();
                hopMeta.setFromStep(transMeta.findStep(hop.getFromStepName()));
                hopMeta.setToStep(transMeta.findStep(hop.getToStepName()));
                hopMeta.setEnabled(hop.isEnabled());
                transMeta.addTransHop(hopMeta);
                continue;
            }
            catch (IOException e) {
                LOGGER.warn(Messages.getString("WARNING.Deserialization.Trans.Hops"), (Throwable)e);
            }
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(TransMetaJsonDeserializer.class);
    }
}

