/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl.model.kettle.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.pentaho.metaverse.impl.model.kettle.json.BaseStepMetaJsonSerializer;
import org.pentaho.metaverse.impl.model.kettle.json.JobEntryBaseJsonSerializer;
import org.pentaho.metaverse.impl.model.kettle.json.JobMetaJsonSerializer;
import org.pentaho.metaverse.impl.model.kettle.json.TableOutputStepMetaJsonSerializer;
import org.pentaho.metaverse.impl.model.kettle.json.TransMetaJsonDeserializer;
import org.pentaho.metaverse.impl.model.kettle.json.TransMetaJsonSerializer;

public class KettleObjectMapper {
    private ObjectMapper mapper;
    private SimpleModule transModule;
    private static KettleObjectMapper instance;

    public static KettleObjectMapper getInstance() {
        if (null == instance) {
            instance = new KettleObjectMapper();
        }
        return instance;
    }

    private KettleObjectMapper() {
        ArrayList<StdSerializer> serializers = new ArrayList<StdSerializer>();
        serializers.add(BaseStepMetaJsonSerializer.getInstance());
        serializers.add(TableOutputStepMetaJsonSerializer.getInstance());
        serializers.add(TransMetaJsonSerializer.getInstance());
        serializers.add(JobEntryBaseJsonSerializer.getInstance());
        serializers.add(JobMetaJsonSerializer.getInstance());
        ArrayList<StdDeserializer> deserializers = new ArrayList<StdDeserializer>();
        deserializers.add(TransMetaJsonDeserializer.getInstance());
        this.doInit(serializers, deserializers);
    }

    @VisibleForTesting
    KettleObjectMapper(List<StdSerializer> serializers, List<StdDeserializer> deserializers) {
        this.doInit(serializers, deserializers);
    }

    private void doInit(List<StdSerializer> serializers, List<StdDeserializer> deserializers) {
        this.mapper = new ObjectMapper();
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.mapper.enable(SerializationFeature.WRAP_EXCEPTIONS);
        this.transModule = new SimpleModule("PDIModule", new Version(1, 0, 0, null));
        if (!CollectionUtils.isEmpty(serializers)) {
            for (StdSerializer serializer : serializers) {
                this.transModule.addSerializer((JsonSerializer)serializer);
            }
        }
        if (!CollectionUtils.isEmpty(deserializers)) {
            for (StdDeserializer deserializer : deserializers) {
                this.transModule.addDeserializer(deserializer.getValueClass(), (JsonDeserializer)deserializer);
            }
        }
        this.mapper.registerModule((Module)this.transModule);
    }

    public <T> T readValue(String json, Class<T> clazz) throws IOException {
        return (T)this.mapper.readValue(json, clazz);
    }

    public String writeValueAsString(Object obj) throws JsonProcessingException {
        return this.mapper.writeValueAsString(obj);
    }
}

