/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileDepthSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.metaverse.api.ILineageCollector;
import org.pentaho.metaverse.impl.MetaverseConfig;
import org.pentaho.metaverse.impl.VfsLineageWriter;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.util.VfsDateRangeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfsLineageCollector
implements ILineageCollector {
    public static final String DEFAULT_OUTPUT_FOLDER = "tmp://dir";
    private String outputFolder = "tmp://dir";
    private static final Logger log = LoggerFactory.getLogger(VfsLineageCollector.class);
    protected SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");

    public VfsLineageCollector() {
        this.format.setLenient(false);
        this.setOutputFolder(MetaverseConfig.getInstance().getExecutionOutputFolder());
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        int seperatorIndex = outputFolder.indexOf(":");
        if (seperatorIndex > -1) {
            String prefix = outputFolder.substring(0, outputFolder.indexOf(":"));
            if (VfsLineageWriter.isVFSPrefix(prefix)) {
                this.outputFolder = outputFolder;
            } else {
                File localFile = new File(outputFolder);
                try {
                    this.outputFolder = "file://" + localFile.getCanonicalPath();
                }
                catch (IOException e) {
                    log.error(Messages.getString("ERROR.CantUseOutputFile", outputFolder), (Throwable)e);
                }
            }
        } else {
            File localFile = new File(outputFolder);
            try {
                this.outputFolder = "file://" + localFile.getCanonicalPath();
            }
            catch (IOException e) {
                log.error(Messages.getString("ERROR.CantUseOutputFile", outputFolder), (Throwable)e);
            }
        }
    }

    public List<String> listArtifacts() throws IllegalArgumentException {
        return this.listArtifacts(null, null);
    }

    public List<String> listArtifacts(String startingDate) throws IllegalArgumentException {
        return this.listArtifacts(startingDate, null);
    }

    public List<String> listArtifacts(String startingDate, String endingDate) throws IllegalArgumentException {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            FileSystemOptions opts = new FileSystemOptions();
            FileObject lineageRootFolder = KettleVFS.getFileObject((String)this.getOutputFolder(), (FileSystemOptions)opts);
            VfsDateRangeFilter dateRangeFilter = new VfsDateRangeFilter(this.format, startingDate, endingDate);
            FileDepthSelector depthFilter = new FileDepthSelector(1, 256);
            if (lineageRootFolder.exists() && lineageRootFolder.getType() == FileType.FOLDER) {
                FileObject[] dayFolders;
                for (FileObject dayFolder : dayFolders = lineageRootFolder.findFiles((FileSelector)dateRangeFilter)) {
                    FileObject[] listThisFolder;
                    for (FileObject currentFile : listThisFolder = dayFolder.findFiles((FileSelector)depthFilter)) {
                        if (currentFile.getType() != FileType.FILE) continue;
                        paths.add(currentFile.getName().getPath());
                    }
                }
            }
            return paths;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public List<String> listArtifactsForFile(String pathToArtifact) throws IllegalArgumentException {
        return this.listArtifactsForFile(pathToArtifact, null);
    }

    public List<String> listArtifactsForFile(String pathToArtifact, String startingDate) {
        return this.listArtifactsForFile(pathToArtifact, startingDate, null);
    }

    public List<String> listArtifactsForFile(String pathToArtifact, String startingDate, String endingDate) throws IllegalArgumentException {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            FileSystemOptions opts = new FileSystemOptions();
            FileObject lineageRootFolder = KettleVFS.getFileObject((String)this.getOutputFolder(), (FileSystemOptions)opts);
            VfsDateRangeFilter dateRangeFilter = new VfsDateRangeFilter(this.format, startingDate, endingDate);
            FileDepthSelector depthFilter = new FileDepthSelector(1, 256);
            if (lineageRootFolder.exists() && lineageRootFolder.getType() == FileType.FOLDER) {
                FileObject[] dayFolders;
                for (FileObject dayFolder : dayFolders = lineageRootFolder.findFiles((FileSelector)dateRangeFilter)) {
                    FileObject[] listThisFolder;
                    for (FileObject currentFile : listThisFolder = dayFolder.findFiles((FileSelector)depthFilter)) {
                        FileObject[] requestedChildren;
                        FileObject requested = currentFile.resolveFile(pathToArtifact);
                        if (!requested.exists() || requested.getType() != FileType.FOLDER) continue;
                        for (FileObject requestedChild : requestedChildren = requested.getChildren()) {
                            if (requestedChild.getType() != FileType.FILE) continue;
                            paths.add(requestedChild.getName().getPath());
                        }
                    }
                }
            }
            return paths;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressArtifacts(List<String> paths, OutputStream os) {
        ZipOutputStream zos = null;
        try {
            FileSystemOptions opts = new FileSystemOptions();
            zos = new ZipOutputStream(os);
            for (String path : paths) {
                FileObject file = KettleVFS.getFileObject((String)path, (FileSystemOptions)opts);
                try {
                    ZipEntry zipEntry = new ZipEntry(file.getName().getPath());
                    zos.putNextEntry(zipEntry);
                    InputStream fis = file.getContent().getInputStream();
                    try {
                        zos.write(IOUtils.toByteArray((InputStream)fis));
                    }
                    finally {
                        if (fis == null) continue;
                        fis.close();
                    }
                }
                catch (IOException e) {
                    log.error(Messages.getString("ERROR.FailedAddingFileToZip", file.getName().getPath()));
                }
                finally {
                    try {
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        log.error(Messages.getString("ERROR.FailedToProperlyCloseZipEntry", file.getName().getPath()));
                    }
                }
            }
        }
        catch (KettleFileException e) {
            try {
                log.error(Messages.getString("ERROR.UnexpectedVfsError", e.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)zos);
        }
        IOUtils.closeQuietly((OutputStream)zos);
    }
}

