/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.stringscut;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.stringcut.StringCutMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;

public class StringsCutStepAnalyzer
extends StepAnalyzer<StringCutMeta> {
    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> set = new HashSet<Class<? extends BaseStepMeta>>(1);
        set.add(StringCutMeta.class);
        return set;
    }

    public Set<ComponentDerivationRecord> getChangeRecords(StringCutMeta meta) throws MetaverseAnalyzerException {
        HashSet<ComponentDerivationRecord> changeRecords = new HashSet<ComponentDerivationRecord>();
        for (int i = 0; i < meta.getFieldInStream().length; ++i) {
            String fieldInString = meta.getFieldInStream()[i];
            String fieldOutString = meta.getFieldOutStream()[i];
            if (fieldOutString == null || fieldOutString.length() < 1) {
                fieldOutString = fieldInString;
            }
            ComponentDerivationRecord changeRecord = new ComponentDerivationRecord(fieldInString, fieldOutString, ChangeType.DATA);
            String changeOperation = fieldInString + " -> [ substring [ " + meta.getCutFrom()[i] + ", " + meta.getCutTo()[i] + " ] ] -> " + fieldOutString;
            changeRecord.addOperation(new Operation("calculation", ChangeType.DATA, "transforms", changeOperation));
            changeRecords.add(changeRecord);
        }
        return changeRecords;
    }

    protected Set<StepField> getUsedFields(StringCutMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        for (String fieldInString : meta.getFieldInStream()) {
            usedFields.addAll(this.createStepFields(fieldInString, this.getInputs()));
        }
        return usedFields;
    }

    protected boolean isPassthrough(StepField originalFieldName) {
        String[] inFields = ((StringCutMeta)this.baseStepMeta).getFieldInStream();
        String origFieldName = originalFieldName.getFieldName();
        for (int i = 0; i < inFields.length; ++i) {
            if (!inFields[i].equals(origFieldName) || !Const.isEmpty((String)((StringCutMeta)this.baseStepMeta).getFieldOutStream()[i])) continue;
            return false;
        }
        return true;
    }

    protected void customAnalyze(StringCutMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
    }

    protected void setStepMeta(StringCutMeta meta) {
        this.baseStepMeta = meta;
    }
}

