/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.rest;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.steps.rest.Rest;
import org.pentaho.di.trans.steps.rest.RestMeta;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.analyzer.kettle.step.BaseStepExternalResourceConsumer;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.pentaho.metaverse.api.model.WebServiceResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientExternalResourceConsumer
extends BaseStepExternalResourceConsumer<Rest, RestMeta> {
    private static RestClientExternalResourceConsumer instance;
    private Logger log = LoggerFactory.getLogger(RestClientExternalResourceConsumer.class);

    @VisibleForTesting
    protected RestClientExternalResourceConsumer() {
    }

    public static RestClientExternalResourceConsumer getInstance() {
        if (null == instance) {
            instance = new RestClientExternalResourceConsumer();
        }
        return instance;
    }

    public Collection<IExternalResourceInfo> getResourcesFromMeta(RestMeta meta, IAnalysisContext context) {
        ArrayList<IExternalResourceInfo> resources = new ArrayList<IExternalResourceInfo>();
        if (!meta.isUrlInField()) {
            String url = meta.getUrl();
            WebServiceResourceInfo resourceInfo = this.createResourceInfo(url, meta);
            resources.add((IExternalResourceInfo)resourceInfo);
        }
        return resources;
    }

    private WebServiceResourceInfo createResourceInfo(String url, RestMeta meta) {
        WebServiceResourceInfo resourceInfo = (WebServiceResourceInfo)ExternalResourceInfoFactory.createURLResource((String)url, (boolean)true);
        if (!meta.isDynamicMethod()) {
            resourceInfo.setMethod(meta.getMethod());
        }
        if (StringUtils.isNotEmpty((String)meta.getBodyField())) {
            resourceInfo.setBody(meta.getBodyField());
        }
        resourceInfo.setApplicationType(meta.getApplicationType());
        return resourceInfo;
    }

    public Collection<IExternalResourceInfo> getResourcesFromRow(Rest step, RowMetaInterface rowMeta, Object[] row) {
        HashSet<IExternalResourceInfo> resources = new HashSet<IExternalResourceInfo>();
        RestMeta meta = (RestMeta)step.getStepMetaInterface();
        if (meta == null) {
            meta = (RestMeta)step.getStepMeta().getStepMetaInterface();
        }
        if (meta != null) {
            try {
                String url = meta.isUrlInField() ? rowMeta.getString(row, meta.getUrlField(), null) : meta.getUrl();
                if (StringUtils.isNotEmpty((String)url)) {
                    String label;
                    String field;
                    int i;
                    WebServiceResourceInfo resourceInfo = this.createResourceInfo(url, meta);
                    if (ArrayUtils.isNotEmpty((Object[])meta.getHeaderField())) {
                        for (i = 0; i < meta.getHeaderField().length; ++i) {
                            field = meta.getHeaderField()[i];
                            label = meta.getHeaderName()[i];
                            resourceInfo.addHeader(label, (Object)rowMeta.getString(row, field, null));
                        }
                    }
                    if (ArrayUtils.isNotEmpty((Object[])meta.getParameterField())) {
                        for (i = 0; i < meta.getParameterField().length; ++i) {
                            field = meta.getParameterField()[i];
                            label = meta.getParameterName()[i];
                            resourceInfo.addParameter(label, (Object)rowMeta.getString(row, field, null));
                        }
                    }
                    if (meta.isDynamicMethod()) {
                        String method = rowMeta.getString(row, meta.getMethodFieldName(), null);
                        resourceInfo.setMethod(method);
                    }
                    if (StringUtils.isNotEmpty((String)meta.getBodyField())) {
                        String body = rowMeta.getString(row, meta.getBodyField(), null);
                        resourceInfo.setBody(body);
                    }
                    resources.add((IExternalResourceInfo)resourceInfo);
                }
            }
            catch (KettleValueException e) {
                this.log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return resources;
    }

    public boolean isDataDriven(RestMeta meta) {
        return true;
    }

    public Class<RestMeta> getMetaClass() {
        return RestMeta.class;
    }
}

