/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.filterrows;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.core.Condition;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRowsStepAnalyzer
extends StepAnalyzer<FilterRowsMeta> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterRowsStepAnalyzer.class);
    public static final String DATA_FLOW_CONDITION = "dataFlowCondition";

    protected void customAnalyze(FilterRowsMeta stepMeta, IMetaverseNode stepNode) {
        Condition condition = stepMeta.getCondition();
        if (condition != null) {
            String filterCondition = condition.toString();
            Operation operation = new Operation("filter", ChangeType.DATA_FLOW, DATA_FLOW_CONDITION, filterCondition);
            ComponentDerivationRecord changeRecord = new ComponentDerivationRecord(stepNode.getName(), ChangeType.DATA_FLOW);
            changeRecord.addOperation(operation);
            stepNode.setProperty("operations", (Object)changeRecord.toString());
        }
    }

    protected Set<StepField> getUsedFields(FilterRowsMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        Condition condition = meta.getCondition();
        if (condition != null) {
            for (String usedField : condition.getUsedFields()) {
                usedFields.addAll(this.createStepFields(usedField, this.getInputs()));
            }
        }
        return usedFields;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> supportedSteps = new HashSet<Class<? extends BaseStepMeta>>();
        supportedSteps.add(FilterRowsMeta.class);
        return supportedSteps;
    }

    public IClonableStepAnalyzer newInstance() {
        return new FilterRowsStepAnalyzer();
    }
}

