/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepExternalResourceConsumerProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class StepExternalResourceConsumerProvider
implements IStepExternalResourceConsumerProvider {
    private List<IStepExternalResourceConsumer> stepConsumers;
    private Map<Class<? extends BaseStepMeta>, Set<IStepExternalResourceConsumer>> stepConsumerMap = new ConcurrentHashMap<Class<? extends BaseStepMeta>, Set<IStepExternalResourceConsumer>>();
    private static StepExternalResourceConsumerProvider instance;

    public static StepExternalResourceConsumerProvider getInstance() {
        if (null == instance) {
            instance = new StepExternalResourceConsumerProvider();
        }
        return instance;
    }

    @VisibleForTesting
    public static void clearInstance() {
        instance = null;
    }

    @VisibleForTesting
    private StepExternalResourceConsumerProvider() {
        this.stepConsumers = Collections.synchronizedList(new ArrayList());
    }

    public void setExternalResourceConsumers(List<IStepExternalResourceConsumer> stepConsumers) {
        this.stepConsumers = stepConsumers;
        this.loadStepExternalResourceConsumerMap();
    }

    public List<IStepExternalResourceConsumer> getExternalResourceConsumers() {
        if (null == this.stepConsumers || this.stepConsumers.isEmpty()) {
            this.stepConsumers = Collections.synchronizedList(new ArrayList());
            this.stepConsumers.addAll(PentahoSystem.getAll(IStepExternalResourceConsumer.class));
        }
        return this.stepConsumers;
    }

    public List<IStepExternalResourceConsumer> getExternalResourceConsumers(Collection<Class<?>> types) {
        List<IStepExternalResourceConsumer> stepExternalResourceConsumers = this.getExternalResourceConsumers();
        if (types != null) {
            HashSet specificStepAnalyzers = new HashSet();
            for (Class<?> clazz : types) {
                if (!this.getStepConsumerMap().containsKey(clazz)) continue;
                specificStepAnalyzers.addAll(this.getStepConsumerMap().get(clazz));
            }
            stepExternalResourceConsumers = new ArrayList<IStepExternalResourceConsumer>(specificStepAnalyzers);
        }
        return stepExternalResourceConsumers;
    }

    public void addExternalResourceConsumer(IStepExternalResourceConsumer externalResourceConsumer) {
        Class metaClass;
        if (!this.stepConsumers.contains(externalResourceConsumer)) {
            this.stepConsumers.add(externalResourceConsumer);
        }
        if ((metaClass = externalResourceConsumer.getMetaClass()) != null) {
            Set consumerSet = this.stepConsumerMap.computeIfAbsent(metaClass, k -> new HashSet());
            consumerSet.add(externalResourceConsumer);
            this.stepConsumerMap.put(metaClass, consumerSet);
        }
    }

    public void removeExternalResourceConsumer(IStepExternalResourceConsumer externalResourceConsumer) {
        Class metaClass;
        if (this.stepConsumers.contains(externalResourceConsumer)) {
            try {
                this.stepConsumers.remove(externalResourceConsumer);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (externalResourceConsumer != null && (metaClass = externalResourceConsumer.getMetaClass()) != null) {
            Set<IStepExternalResourceConsumer> consumerSet = null;
            if (this.stepConsumerMap.containsKey(metaClass)) {
                consumerSet = this.stepConsumerMap.get(metaClass);
                consumerSet.remove(externalResourceConsumer);
                if (consumerSet.isEmpty()) {
                    this.stepConsumerMap.remove(metaClass);
                }
            }
        }
    }

    public Map<Class<? extends BaseStepMeta>, Set<IStepExternalResourceConsumer>> getStepConsumerMap() {
        if (null == this.stepConsumerMap || this.stepConsumerMap.isEmpty()) {
            this.stepConsumerMap = new ConcurrentHashMap<Class<? extends BaseStepMeta>, Set<IStepExternalResourceConsumer>>();
            List<IStepExternalResourceConsumer> consumerList = this.getExternalResourceConsumers();
            for (IStepExternalResourceConsumer consumer : consumerList) {
                Class metaClass = consumer.getMetaClass();
                if (metaClass == null) continue;
                Set consumerSet = this.stepConsumerMap.computeIfAbsent(metaClass, k -> new HashSet());
                consumerSet.add(consumer);
                this.stepConsumerMap.put(metaClass, consumerSet);
            }
        }
        return this.stepConsumerMap;
    }

    protected void loadStepExternalResourceConsumerMap() {
        this.stepConsumerMap = this.getStepConsumerMap();
    }
}

