/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.metaverse.api.analyzer.kettle.BaseKettleMetaverseComponent;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzerProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class StepAnalyzerProvider
extends BaseKettleMetaverseComponent
implements IStepAnalyzerProvider {
    private static StepAnalyzerProvider instance;
    protected List<IStepAnalyzer> stepAnalyzers = new ArrayList<IStepAnalyzer>();
    protected Map<Class<? extends BaseStepMeta>, Set<IStepAnalyzer>> analyzerTypeMap = new HashMap<Class<? extends BaseStepMeta>, Set<IStepAnalyzer>>();

    @VisibleForTesting
    StepAnalyzerProvider() {
    }

    public static StepAnalyzerProvider getInstance() {
        if (null == instance) {
            instance = new StepAnalyzerProvider();
        }
        return instance;
    }

    public List<IStepAnalyzer> getAnalyzers() {
        if (null == this.stepAnalyzers || this.stepAnalyzers.isEmpty()) {
            this.stepAnalyzers = Collections.synchronizedList(new ArrayList());
            this.stepAnalyzers.addAll(PentahoSystem.getAll(IStepAnalyzer.class));
            this.loadAnalyzerTypeMap();
        }
        return this.stepAnalyzers;
    }

    public List<IStepAnalyzer> getAnalyzers(Collection<Class<?>> types) {
        List<IStepAnalyzer> stepAnalyzers = this.getAnalyzers();
        if (types != null) {
            HashSet specificStepAnalyzers = new HashSet();
            for (Class<?> clazz : types) {
                if (!this.analyzerTypeMap.containsKey(clazz)) continue;
                specificStepAnalyzers.addAll(this.analyzerTypeMap.get(clazz));
            }
            stepAnalyzers = new ArrayList<IStepAnalyzer>(specificStepAnalyzers);
        }
        return stepAnalyzers;
    }

    public void setStepAnalyzers(List<IStepAnalyzer> analyzers) {
        if (analyzers == null) {
            this.stepAnalyzers = null;
        } else {
            if (this.stepAnalyzers == null) {
                this.stepAnalyzers = new ArrayList<IStepAnalyzer>();
            }
            for (IStepAnalyzer analyzer : analyzers) {
                if (this.stepAnalyzers.contains(analyzer)) continue;
                this.stepAnalyzers.add(analyzer);
            }
            this.loadAnalyzerTypeMap();
        }
    }

    public void setClonableStepAnalyzers(List<IStepAnalyzer> analyzers) {
        this.setStepAnalyzers(analyzers);
    }

    protected void loadAnalyzerTypeMap() {
        this.analyzerTypeMap = new HashMap<Class<? extends BaseStepMeta>, Set<IStepAnalyzer>>();
        if (this.stepAnalyzers != null) {
            for (IStepAnalyzer analyzer : this.stepAnalyzers) {
                this.addAnalyzer(analyzer);
            }
        }
    }

    public void addAnalyzer(IStepAnalyzer analyzer) {
        if (analyzer != null) {
            Set types;
            if (!this.stepAnalyzers.contains(analyzer)) {
                this.stepAnalyzers.add(analyzer);
            }
            if ((types = analyzer.getSupportedSteps()) != null) {
                for (Class type : types) {
                    Set<IStepAnalyzer> analyzerSet = this.analyzerTypeMap.containsKey(type) ? this.analyzerTypeMap.get(type) : new HashSet<IStepAnalyzer>();
                    analyzerSet.add(analyzer);
                    this.analyzerTypeMap.put(type, analyzerSet);
                }
            }
        }
    }

    public void addClonableAnalyzer(IClonableStepAnalyzer analyzer) {
        this.addAnalyzer((IStepAnalyzer)analyzer);
    }

    public void removeAnalyzer(IStepAnalyzer analyzer) {
        if (analyzer != null) {
            Set types;
            if (this.stepAnalyzers != null && this.stepAnalyzers.contains(analyzer)) {
                try {
                    this.stepAnalyzers.remove(analyzer);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            if ((types = analyzer.getSupportedSteps()) != null) {
                for (Class type : types) {
                    if (!this.analyzerTypeMap.containsKey(type)) continue;
                    Set<IStepAnalyzer> analyzerSet = this.analyzerTypeMap.get(type);
                    analyzerSet.remove(analyzer);
                    if (analyzerSet.size() != 0) continue;
                    this.analyzerTypeMap.remove(type);
                }
            }
        }
    }

    public void removeClonableAnalyzer(IClonableStepAnalyzer analyzer) {
        this.removeAnalyzer((IStepAnalyzer)analyzer);
    }
}

