/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.jobentry;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryExternalResourceConsumer;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryExternalResourceConsumerProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class JobEntryExternalResourceConsumerProvider
implements IJobEntryExternalResourceConsumerProvider {
    private List<IJobEntryExternalResourceConsumer> jobEntryExternalResourceConsumers;
    private Map<Class<? extends JobEntryBase>, Set<IJobEntryExternalResourceConsumer>> jobEntryConsumerMap = new ConcurrentHashMap<Class<? extends JobEntryBase>, Set<IJobEntryExternalResourceConsumer>>();
    private static JobEntryExternalResourceConsumerProvider instance;

    public static JobEntryExternalResourceConsumerProvider getInstance() {
        if (null == instance) {
            instance = new JobEntryExternalResourceConsumerProvider();
        }
        return instance;
    }

    @VisibleForTesting
    public static void clearInstance() {
        instance = null;
    }

    private JobEntryExternalResourceConsumerProvider() {
        this.jobEntryExternalResourceConsumers = Collections.synchronizedList(new ArrayList());
    }

    public void setExternalResourceConsumers(List<IJobEntryExternalResourceConsumer> jobEntryConsumers) {
        this.jobEntryExternalResourceConsumers = jobEntryConsumers;
        this.loadJobEntryExternalResourceConsumerMap();
    }

    public List<IJobEntryExternalResourceConsumer> getExternalResourceConsumers() {
        if (null == this.jobEntryExternalResourceConsumers || this.jobEntryExternalResourceConsumers.isEmpty()) {
            this.jobEntryExternalResourceConsumers = Collections.synchronizedList(new ArrayList());
            this.jobEntryExternalResourceConsumers.addAll(PentahoSystem.getAll(IJobEntryExternalResourceConsumer.class));
        }
        return this.jobEntryExternalResourceConsumers;
    }

    public List<IJobEntryExternalResourceConsumer> getExternalResourceConsumers(Collection<Class<?>> types) {
        List<IJobEntryExternalResourceConsumer> jobEntryConsumers = this.getExternalResourceConsumers();
        if (types != null) {
            HashSet specificJobEntryAnalyzers = new HashSet();
            for (Class<?> clazz : types) {
                if (!this.getJobEntryConsumerMap().containsKey(clazz)) continue;
                specificJobEntryAnalyzers.addAll(this.getJobEntryConsumerMap().get(clazz));
            }
            jobEntryConsumers = new ArrayList<IJobEntryExternalResourceConsumer>(specificJobEntryAnalyzers);
        }
        return jobEntryConsumers;
    }

    public void addExternalResourceConsumer(IJobEntryExternalResourceConsumer externalResourceConsumer) {
        Class metaClass;
        if (!this.jobEntryExternalResourceConsumers.contains(externalResourceConsumer)) {
            this.jobEntryExternalResourceConsumers.add(externalResourceConsumer);
        }
        if ((metaClass = externalResourceConsumer.getMetaClass()) != null) {
            Set consumerSet = this.jobEntryConsumerMap.computeIfAbsent(metaClass, k -> new HashSet());
            consumerSet.add(externalResourceConsumer);
            this.jobEntryConsumerMap.put(metaClass, consumerSet);
        }
    }

    public void removeExternalResourceConsumer(IJobEntryExternalResourceConsumer externalResourceConsumer) {
        Class metaClass;
        if (this.jobEntryExternalResourceConsumers.contains(externalResourceConsumer)) {
            try {
                this.jobEntryExternalResourceConsumers.remove(externalResourceConsumer);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (externalResourceConsumer != null && (metaClass = externalResourceConsumer.getMetaClass()) != null) {
            Set<IJobEntryExternalResourceConsumer> consumerSet = null;
            if (this.jobEntryConsumerMap.containsKey(metaClass)) {
                consumerSet = this.jobEntryConsumerMap.get(metaClass);
                consumerSet.remove(externalResourceConsumer);
                if (consumerSet.isEmpty()) {
                    this.jobEntryConsumerMap.remove(metaClass);
                }
            }
        }
    }

    public Map<Class<? extends JobEntryBase>, Set<IJobEntryExternalResourceConsumer>> getJobEntryConsumerMap() {
        if (null == this.jobEntryConsumerMap || this.jobEntryConsumerMap.isEmpty()) {
            this.jobEntryConsumerMap = new ConcurrentHashMap<Class<? extends JobEntryBase>, Set<IJobEntryExternalResourceConsumer>>();
            List<IJobEntryExternalResourceConsumer> consumerList = this.getExternalResourceConsumers();
            for (IJobEntryExternalResourceConsumer consumer : consumerList) {
                Class metaClass = consumer.getMetaClass();
                if (metaClass == null) continue;
                Set consumerSet = this.jobEntryConsumerMap.computeIfAbsent(metaClass, k -> new HashSet());
                consumerSet.add(consumer);
                this.jobEntryConsumerMap.put(metaClass, consumerSet);
            }
        }
        return this.jobEntryConsumerMap;
    }

    protected void loadJobEntryExternalResourceConsumerMap() {
        this.jobEntryConsumerMap = this.getJobEntryConsumerMap();
    }
}

