/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.job.entry;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.JobEntryListener;
import org.pentaho.di.job.JobExecutionExtension;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.job.JobLineageHolderMap;
import org.pentaho.metaverse.analyzer.kettle.extensionpoints.job.entry.JobEntryExternalResourceListener;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryExternalResourceConsumer;
import org.pentaho.metaverse.api.analyzer.kettle.jobentry.IJobEntryExternalResourceConsumerProvider;
import org.pentaho.metaverse.api.model.IExecutionProfile;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.pentaho.metaverse.util.MetaverseBeanUtil;

@ExtensionPoint(description="Job entry external resource listener", extensionPointId="JobBeforeJobEntryExecution", id="jobEntryExternalResource")
public class JobEntryExternalResourceConsumerListener
implements ExtensionPointInterface {
    private IJobEntryExternalResourceConsumerProvider jobEntryConsumerProvider;

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        Class<?> metaClass;
        JobEntryInterface meta;
        if (this.jobEntryConsumerProvider == null) {
            this.jobEntryConsumerProvider = (IJobEntryExternalResourceConsumerProvider)MetaverseBeanUtil.getInstance().get(IJobEntryExternalResourceConsumerProvider.class);
        }
        JobExecutionExtension jobExec = (JobExecutionExtension)object;
        JobEntryCopy jobEntryCopy = jobExec.jobEntryCopy;
        if (jobEntryCopy != null && (meta = jobEntryCopy.getEntry()) != null && JobEntryBase.class.isAssignableFrom(metaClass = meta.getClass()) && this.jobEntryConsumerProvider != null) {
            HashSet metaClassSet = new HashSet(1);
            metaClassSet.add(metaClass);
            List jobEntryConsumers = this.jobEntryConsumerProvider.getExternalResourceConsumers(metaClassSet);
            if (jobEntryConsumers != null) {
                for (IJobEntryExternalResourceConsumer jobEntryConsumer : jobEntryConsumers) {
                    Collection resources = jobEntryConsumer.getResourcesFromMeta((Object)meta);
                    this.addExternalResources(resources, meta);
                    if (jobExec.job == null || !jobEntryConsumer.isDataDriven((Object)meta)) continue;
                    if (jobEntryConsumer instanceof JobEntryExternalResourceListener) {
                        jobExec.job.addJobEntryListener((JobEntryListener)((JobEntryExternalResourceListener)jobEntryConsumer));
                        continue;
                    }
                    jobExec.job.addJobEntryListener((JobEntryListener)new JobEntryExternalResourceListener());
                }
            } else if (jobExec.job != null) {
                jobExec.job.addJobEntryListener((JobEntryListener)new JobEntryExternalResourceListener());
            }
        }
    }

    protected void addExternalResources(Collection<IExternalResourceInfo> resources, JobEntryInterface jobEntry) {
        IExecutionProfile executionProfile;
        if (resources != null && (executionProfile = JobLineageHolderMap.getInstance().getLineageHolder(jobEntry.getParentJob()).getExecutionProfile()) != null) {
            String jobEntryName = jobEntry.getName();
            Map resourceMap = executionProfile.getExecutionData().getExternalResources();
            LinkedList<IExternalResourceInfo> externalResources = (LinkedList<IExternalResourceInfo>)resourceMap.get(jobEntryName);
            if (externalResources == null) {
                externalResources = new LinkedList<IExternalResourceInfo>();
            }
            externalResources.addAll(resources);
            resourceMap.put(jobEntryName, externalResources);
        }
    }

    public void setJobEntryExternalResourceConsumerProvider(IJobEntryExternalResourceConsumerProvider provider) {
        this.jobEntryConsumerProvider = provider;
    }
}

