/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.metaverse.analyzer.kettle.AnalyzerHolder;
import org.pentaho.metaverse.analyzer.kettle.BaseDocumentAnalyzer;
import org.pentaho.metaverse.analyzer.kettle.step.GenericStepMetaAnalyzer;
import org.pentaho.metaverse.analyzer.kettle.step.StepAnalyzerProvider;
import org.pentaho.metaverse.api.IAnalyzer;
import org.pentaho.metaverse.api.IClonableDocumentAnalyzer;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IMetaverseLink;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.Namespace;
import org.pentaho.metaverse.api.PropertiesHolder;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.AnnotatedClassFields;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.AnnotationDrivenStepMetaAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.IStepAnalyzerProvider;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationAnalyzer
extends BaseDocumentAnalyzer {
    private static final long serialVersionUID = 3147152759123052372L;
    protected static final Set<String> defaultSupportedTypes = new HashSet<String>(){
        private static final long serialVersionUID = -7433589337075366681L;
        {
            this.add("ktr");
        }
    };
    private IStepAnalyzerProvider stepAnalyzerProvider = StepAnalyzerProvider.getInstance();
    private static final Logger log = LoggerFactory.getLogger(TransformationAnalyzer.class);

    public synchronized IMetaverseNode analyze(IComponentDescriptor descriptor, IDocument document) throws MetaverseAnalyzerException {
        TransMeta transMeta;
        block5: {
            this.validateState(document);
            Object repoObject = document.getContent();
            transMeta = null;
            if (repoObject instanceof String) {
                try {
                    String content = (String)repoObject;
                    ByteArrayInputStream xmlStream = new ByteArrayInputStream(content.getBytes());
                    transMeta = new TransMeta((InputStream)xmlStream, null, false, null, null);
                    transMeta.setFilename(document.getStringID());
                    if (transMeta.hasMissingPlugins()) {
                        throw new MetaverseAnalyzerException(Messages.getErrorString("ERROR.MissingPlugin"));
                    }
                    break block5;
                }
                catch (KettleException e) {
                    throw new MetaverseAnalyzerException((Throwable)e);
                }
            }
            if (repoObject instanceof TransMeta) {
                transMeta = (TransMeta)repoObject;
            }
        }
        MetaverseComponentDescriptor documentDescriptor = new MetaverseComponentDescriptor(document.getStringID(), "Transformation", (INamespace)new Namespace(descriptor.getLogicalId()), descriptor.getContext());
        IMetaverseNode transNode = this.metaverseObjectFactory.createNodeObject(document.getNamespace(), transMeta.getName(), "Transformation");
        transNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_DOCUMENT);
        return this.analyze((IComponentDescriptor)documentDescriptor, (AbstractMeta)transMeta, transNode, (String)document.getProperty("path"));
    }

    public synchronized IMetaverseNode analyze(IComponentDescriptor documentDescriptor, AbstractMeta meta, IMetaverseNode node, String documentPath) throws MetaverseAnalyzerException {
        String status;
        String version;
        String lastModifiedUser;
        Date lastModifiedDate;
        String createdUser;
        Date createdDate;
        String extendedDescription;
        TransMeta transMeta = (TransMeta)meta;
        Trans t = new Trans(transMeta);
        t.setInternalKettleVariables((VariableSpace)transMeta);
        String description = transMeta.getDescription();
        if (description != null) {
            node.setProperty("description", (Object)description);
        }
        if ((extendedDescription = transMeta.getExtendedDescription()) != null) {
            node.setProperty("extendedDescription", (Object)extendedDescription);
        }
        if ((createdDate = transMeta.getCreatedDate()) != null) {
            node.setProperty("created", (Object)Long.toString(createdDate.getTime()));
        }
        if ((createdUser = transMeta.getCreatedUser()) != null) {
            node.setProperty("createdby", (Object)createdUser);
        }
        if ((lastModifiedDate = transMeta.getModifiedDate()) != null) {
            node.setProperty("lastmodified", (Object)Long.toString(lastModifiedDate.getTime()));
        }
        if ((lastModifiedUser = transMeta.getModifiedUser()) != null) {
            node.setProperty("lastmodifiedby", (Object)lastModifiedUser);
        }
        if ((version = transMeta.getTransversion()) != null) {
            node.setProperty("version", (Object)version);
        }
        if ((status = Messages.getString("INFO.JobOrTrans.Status_" + Integer.toString(transMeta.getTransstatus()))) != null && !status.startsWith("!")) {
            node.setProperty("status", (Object)status);
        }
        node.setProperty("path", (Object)documentPath);
        String[] parameters = transMeta.listParameters();
        if (parameters != null) {
            for (String parameter : parameters) {
                try {
                    String defaultParameterValue = transMeta.getParameterDefault(parameter);
                    String parameterValue = transMeta.getParameterValue(parameter);
                    String parameterDescription = transMeta.getParameterDescription(parameter);
                    PropertiesHolder paramProperties = new PropertiesHolder();
                    paramProperties.setProperty("defaultValue", (Object)defaultParameterValue);
                    paramProperties.setProperty("value", (Object)parameterValue);
                    paramProperties.setProperty("description", (Object)parameterDescription);
                    node.setProperty("parameter_" + parameter, (Object)paramProperties.toString());
                }
                catch (UnknownParamException upe) {
                    throw new MetaverseAnalyzerException((Throwable)upe);
                }
            }
        }
        ArrayList<AnalyzerHolder> analyzerHolders = new ArrayList<AnalyzerHolder>();
        for (int stepNr = 0; stepNr < transMeta.nrSteps(); ++stepNr) {
            StepMeta stepMeta = transMeta.getStep(stepNr);
            try {
                if (stepMeta == null) continue;
                if (stepMeta.getParentTransMeta() == null) {
                    stepMeta.setParentTransMeta(transMeta);
                }
                IMetaverseNode stepNode = null;
                MetaverseComponentDescriptor stepDescriptor = new MetaverseComponentDescriptor(stepMeta.getName(), "Transformation Step", node, documentDescriptor.getContext());
                Set<IStepAnalyzer> stepAnalyzers = this.getStepAnalyzers(stepMeta);
                BaseStepMeta baseStepMeta = this.getBaseStepMetaFromStepMeta(stepMeta);
                if (stepAnalyzers != null && !stepAnalyzers.isEmpty()) {
                    for (IStepAnalyzer stepAnalyzer : stepAnalyzers) {
                        if (stepAnalyzer instanceof IClonableStepAnalyzer) {
                            stepAnalyzer = ((IClonableStepAnalyzer)stepAnalyzer).cloneAnalyzer();
                            ((IClonableStepAnalyzer)stepAnalyzer).setDocumentAnalyzer((IClonableDocumentAnalyzer)this);
                            ((IClonableStepAnalyzer)stepAnalyzer).setDocumentDescriptor(documentDescriptor);
                            ((IClonableStepAnalyzer)stepAnalyzer).setDocumentPath(documentPath);
                        } else {
                            log.debug(Messages.getString("WARNING.CannotCloneAnalyzer"), (Object)stepAnalyzer);
                        }
                        stepAnalyzer.setMetaverseBuilder(this.metaverseBuilder);
                        stepNode = (IMetaverseNode)stepAnalyzer.analyze((IComponentDescriptor)stepDescriptor, (Object)baseStepMeta);
                        analyzerHolders.add(new AnalyzerHolder((IAnalyzer)stepAnalyzer, baseStepMeta, stepNode));
                    }
                } else if (new AnnotatedClassFields(baseStepMeta).hasMetaverseAnnotations()) {
                    AnnotationDrivenStepMetaAnalyzer annotationDrivenStepMetaAnalyzer = new AnnotationDrivenStepMetaAnalyzer(baseStepMeta);
                    annotationDrivenStepMetaAnalyzer.setMetaverseBuilder(this.metaverseBuilder);
                    annotationDrivenStepMetaAnalyzer.setDocumentAnalyzer((IClonableDocumentAnalyzer)this);
                    annotationDrivenStepMetaAnalyzer.setDocumentDescriptor(documentDescriptor);
                    annotationDrivenStepMetaAnalyzer.setDocumentPath(documentPath);
                    stepNode = annotationDrivenStepMetaAnalyzer.analyze((IComponentDescriptor)stepDescriptor, baseStepMeta);
                    analyzerHolders.add(new AnalyzerHolder((IAnalyzer)annotationDrivenStepMetaAnalyzer, baseStepMeta, stepNode));
                } else {
                    GenericStepMetaAnalyzer defaultStepAnalyzer = new GenericStepMetaAnalyzer();
                    defaultStepAnalyzer.setMetaverseBuilder(this.metaverseBuilder);
                    stepNode = defaultStepAnalyzer.analyze((IComponentDescriptor)stepDescriptor, this.getBaseStepMetaFromStepMeta(stepMeta));
                }
                if (stepNode == null) continue;
                this.metaverseBuilder.addLink(node, "contains", stepNode);
                continue;
            }
            catch (Throwable mae) {
                log.warn(Messages.getString("ERROR.ErrorDuringAnalysis", stepMeta.getName(), Const.NVL((String)mae.getLocalizedMessage(), (String)"Unspecified")));
                log.debug(Messages.getString("ERROR.ErrorDuringAnalysisStackTrace"), mae);
            }
        }
        int numHops = transMeta.nrTransHops();
        for (int i = 0; i < numHops; ++i) {
            TransHopMeta hop = transMeta.getTransHop(i);
            StepMeta fromStep = hop.getFromStep();
            StepMeta toStep = hop.getToStep();
            Namespace childNs = new Namespace(node.getLogicalId());
            if (fromStep == null || toStep == null) continue;
            IMetaverseNode fromStepNode = this.metaverseObjectFactory.createNodeObject((INamespace)childNs, fromStep.getName(), "Transformation Step");
            IMetaverseNode toStepNode = this.metaverseObjectFactory.createNodeObject((INamespace)childNs, toStep.getName(), "Transformation Step");
            IMetaverseLink link = this.metaverseObjectFactory.createLinkObject();
            link.setFromNode(fromStepNode);
            link.setLabel("hops_to");
            link.setToNode(toStepNode);
            link.setProperty("enabled", (Object)hop.isEnabled());
            String linkType = "target";
            if (fromStep.isSendingErrorRowsToStep(toStep)) {
                linkType = "error";
            } else {
                String[] infoStepnames = toStep.getStepMetaInterface().getStepIOMeta().getInfoStepnames();
                if (Const.indexOfString((String)fromStep.getName(), (String[])infoStepnames) >= 0) {
                    linkType = "info";
                }
            }
            link.setProperty("type", (Object)linkType);
            this.metaverseBuilder.addLink(link);
        }
        this.metaverseBuilder.addNode(node);
        this.addParentLink(documentDescriptor, node);
        for (AnalyzerHolder analyzerHolder : analyzerHolders) {
            if (!(analyzerHolder.getAnalyzer() instanceof IClonableStepAnalyzer)) continue;
            IClonableStepAnalyzer clonableAnalyzer = (IClonableStepAnalyzer)analyzerHolder.getAnalyzer();
            clonableAnalyzer.postAnalyze(analyzerHolder.getMeta());
        }
        return node;
    }

    public Set<String> getSupportedTypes() {
        return defaultSupportedTypes;
    }

    protected Set<IStepAnalyzer> getStepAnalyzers(StepMeta stepMeta) {
        HashSet<IStepAnalyzer> stepAnalyzers = new HashSet<IStepAnalyzer>();
        BaseStepMeta baseStepMeta = this.getBaseStepMetaFromStepMeta(stepMeta);
        this.stepAnalyzerProvider = this.getStepAnalyzerProvider();
        if (this.stepAnalyzerProvider != null) {
            if (baseStepMeta == null) {
                stepAnalyzers.addAll(this.stepAnalyzerProvider.getAnalyzers());
            } else {
                HashSet analyzerClassSet = new HashSet(1);
                analyzerClassSet.add(baseStepMeta.getClass());
                stepAnalyzers.addAll(this.stepAnalyzerProvider.getAnalyzers(analyzerClassSet));
            }
        } else {
            stepAnalyzers.add((IStepAnalyzer)new GenericStepMetaAnalyzer());
        }
        return stepAnalyzers;
    }

    public void setStepAnalyzerProvider(IStepAnalyzerProvider stepAnalyzerProvider) {
        this.stepAnalyzerProvider = stepAnalyzerProvider;
    }

    public IStepAnalyzerProvider getStepAnalyzerProvider() {
        if (this.stepAnalyzerProvider != null) {
            return this.stepAnalyzerProvider;
        }
        this.stepAnalyzerProvider = (IStepAnalyzerProvider)PentahoSystem.get(IStepAnalyzerProvider.class);
        return this.stepAnalyzerProvider;
    }

    protected BaseStepMeta getBaseStepMetaFromStepMeta(StepMeta stepMeta) {
        StepMetaInterface smi;
        BaseStepMeta baseStepMeta = new BaseStepMeta();
        baseStepMeta.setParentStepMeta(stepMeta);
        if (stepMeta != null && (smi = stepMeta.getStepMetaInterface()) instanceof BaseStepMeta) {
            baseStepMeta = (BaseStepMeta)smi;
        }
        return baseStepMeta;
    }

    @Override
    public IClonableDocumentAnalyzer newInstance() {
        return new TransformationAnalyzer();
    }
}

