/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.KeyAgreementException;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.OIDManager;

public abstract class KeyAgreement {
    protected KeyAgreement() {
    }

    public static KeyAgreement getInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        KeyAgreement keyAgreement;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "keyAgreement");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        try {
            keyAgreement = (KeyAgreement)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement KeyAgreement.");
        }
        keyAgreement.setAlgID(algorithmIdentifier);
        return keyAgreement;
    }

    public static KeyAgreement getInstance(PrivateKey privateKey) throws KeyAgreementException {
        KeyAgreement keyAgreement;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(privateKey.getAlgID().getOID(), "useKeyAgreement");
        if (clazz == null) {
            throw new KeyAgreementException("Cannot find a key agreement algorithm for this key with " + privateKey.getAlgID().getOID());
        }
        try {
            keyAgreement = (KeyAgreement)clazz.newInstance();
            keyAgreement.setPrivateKey(privateKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KeyAgreementException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new KeyAgreementException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new KeyAgreementException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyAgreementException(invalidKeyException.toString());
        }
        return keyAgreement;
    }

    public static KeyAgreement getInstance(PublicKey publicKey) throws KeyAgreementException {
        KeyAgreement keyAgreement;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(publicKey.getAlgID().getOID(), "useKeyAgreement");
        if (clazz == null) {
            throw new KeyAgreementException("Can not find a keyAgreement algorithm for this key with " + publicKey.getAlgID().getOID());
        }
        try {
            keyAgreement = (KeyAgreement)clazz.newInstance();
            keyAgreement.setPublicKey(publicKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KeyAgreementException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new KeyAgreementException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new KeyAgreementException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyAgreementException(invalidKeyException.toString());
        }
        return keyAgreement;
    }

    public abstract void setAlgID(AlgorithmIdentifier var1) throws AlgorithmIdentifierException;

    public abstract AlgorithmIdentifier getAlgID();

    public abstract void setPrivateKey(PrivateKey var1) throws InvalidKeyException;

    public abstract byte[] generateSecret() throws KeyAgreementException;

    public abstract void setPublicKey(PublicKey var1) throws InvalidKeyException;

    public abstract PublicKey getPublicKey();

    public abstract String algName();

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

